# This function can be called with a plot to place information at the bottom of the plot
# to provide a level of accountability as to what software created the plot.
# "script.name: is the name of the script from which this function is called."
# Sample Call: credit("credit.R")
#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
credit <- function(script.name){
# To put text on the lower right hand side of the plot (like to script name and date)
	now.date <- Sys.Date()
	script.txt <- paste("PLV: \"", script.name, "\"  ", now.date, "  ", sep="")
	mtext(script.txt, side=3,  cex=0.75, line=-1, adj=1)
}

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
